/*****************************************************************************
**+------------------------------------------------------------------------+**
**|                                                                        |**
**|                Copyright 2010 Mistral Solutions Pvt Ltd.               |**
**|                                                                        |**
**|                                                                        |**
**|                                                                        |**   
**| This program is free software; you can redistribute it and/or          |**
**| modify it under the terms of the GNU General Public License as         |**
**| published by the Free Software Foundation; either version 2 of         |**
**| the License, or (at your option) any later version.                    |**
**|                                                                        |**
**| This program is distributed in the hope that it will be useful,        |**
**| but WITHOUT ANY WARRANTY; without even the implied warranty of         |**
**| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the           |**
**| GNU General Public License for more details.                           |**
**|                                                                        |**      
**| You should have received a copy of the GNU General Public License      |**
**| along with this program; if not, write to the Free Software            |**
**| Foundation, Inc., 59 Temple Place, Suite 330, Boston,                  |**
**| MA 02111-1307 USA                                                      |**
**+------------------------------------------------------------------------+**
*****************************************************************************/ 
/**
 * \file    nandflash_test.c
 *
 * \brief   Support routines to test the NAND Flash
 *
 * This file contains the suppoort routines for testing the NAND 
 * Flash on the DM814X EVM
 *
 * \author  0043
 *
 * \version 01a,25aug,2010 Created
 */

/*
 *====================
 * Includes
 *====================
 */
#include "stdio.h"
#include "DM814x_EVM.h"
#include "DM814x_types.h"

#include "nandflash.h"

#undef SPARE_CHECK
/** **************************************************************************
 * \n \brief Routine to Test Nandflash device .
 *
 * This routine tests first 4 blocks of device without Spare area.Uncommenting 
 * the  loop tests with spare area.This routine first erases the blocks.Writes 
 * into the device and read the same and Compares both.
 * 
 *
 * \return
 * \n      return 0 for success  
 * \n      return 1 for error   
 */

STATUS nandflash_test( )
{
	STATUS u32RetVal = SUCCESS;
    INT16 status;
    UINT32 i, j, errors, blockstotest;

	static UINT16 src[NANDFLASH_PAGESIZE + NANDFLASH_SPARESIZE];
	static UINT16 dst[NANDFLASH_PAGESIZE + NANDFLASH_SPARESIZE];

    /* Initialize NAND */
    u32RetVal = nand_init();
    if(FAILED == u32RetVal)
    {
    	u32RetVal = FAILED;
        return u32RetVal;
    }
    
    blockstotest = NANDFLASH_BLOCKS_TEST;  /* NANDFLASH_BLOCKS */
    printf("Testing %d blocks\n", blockstotest);

    /* Erase all of NAND */
    printf("Erasing NAND blocks\n");
    errors = 0;
    for (i = 0; i < blockstotest ; i++)
    {
    	u32RetVal = nand_eraseBlock(i);
        if (FAILED == u32RetVal)
		{
            printf(" -- block %d erase error\n", i);
            errors++;
        }
    }
    
    printf("--> %d block erase errors\n", errors);
    if (errors > 80)
    {
    	printf ("Too many block errase failed. Aborting test.!!\r\n");
        return u32RetVal ;
    }

    /* Fill the source buffer */
#ifdef SPARE_CHECK
    for (i = 0; i < (NANDFLASH_PAGESIZE + NANDFLASH_SPARESIZE); i++)
#else
    for (i = 0; i < NANDFLASH_PAGESIZE; i++)
#endif
     src[i] = 0xAAAA;

    /* Clear the destination buffer */
#ifdef SPARE_CHECK
    for (i = 0; i < (NANDFLASH_PAGESIZE + NANDFLASH_SPARESIZE); i++)
#else
    for (i = 0; i < NANDFLASH_PAGESIZE; i++)
#endif
        dst[i] = 0x0000;
	    
    /* Program all pages */
    printf("Programming NAND pages\n");
    for (j = 0; j < (blockstotest * NANDFLASH_PAGESPERBLOCK); j++)
    {
        src[0] = j & 0x000000ff;
        src[1] = (j & 0x0000ff00) >> 8;
        src[2] = (j & 0x00ff0000) >> 16;
        src[3] = (j & 0xff000000) >> 24;

#ifdef SPARE_CHECK
	src[NANDFLASH_PAGESIZE + NANDFLASH_SPARESIZE - 4] =  j & 0x000000ff;
	src[NANDFLASH_PAGESIZE + NANDFLASH_SPARESIZE - 3] = (j & 0x0000ff00) >> 8;
	src[NANDFLASH_PAGESIZE + NANDFLASH_SPARESIZE - 2] = (j & 0x00ff0000) >> 16;
	src[NANDFLASH_PAGESIZE + NANDFLASH_SPARESIZE - 1] = (j & 0xff000000) >> 24;
#endif

#ifdef SPARE_CHECK
	nand_writePage(j, src, NANDFLASH_PAGESIZE + NANDFLASH_SPARESIZE);
#else
    nand_writePage(j, src, NANDFLASH_PAGESIZE);
#endif
    }

    /* Read and compare all pages */
    printf("Comparing data\n");
    errors = 0;
    for (j = 0; j < (blockstotest * NANDFLASH_PAGESPERBLOCK); j++)
    {
#ifdef SPARE_CHECK
    nand_readPage(j, dst, NANDFLASH_PAGESIZE + NANDFLASH_SPARESIZE);
#else
    nand_readPage(j, dst, NANDFLASH_PAGESIZE);
#endif
    status = 0;
    if (dst[0] != (j & 0x000000ff))
        status = 1;
    if (dst[1] != ((j & 0x0000ff00) >> 8))
        status = 1;
    if (dst[2] != ((j & 0x00ff0000) >> 16))
        status = 1;
    if (dst[3] != ((j & 0xff000000) >> 24))
        status = 1;

#ifdef SPARE_CHECK
	if (dst[NANDFLASH_PAGESIZE + NANDFLASH_SPARESIZE - 1] != ((j & 0xff000000) >> 24))
	    status = 1;
	if (dst[NANDFLASH_PAGESIZE + NANDFLASH_SPARESIZE - 2] != ((j & 0x00ff0000) >> 16))
	    status = 1;
	if (dst[NANDFLASH_PAGESIZE + NANDFLASH_SPARESIZE - 3] != ((j & 0x0000ff00) >> 8))
	    status = 1;
	if (dst[NANDFLASH_PAGESIZE + NANDFLASH_SPARESIZE - 4] != (j & 0x000000ff))
	    status = 1;
#endif

	if (status)
	  {
            errors++;
	  }
	if (status)
	  {
	    printf("Error on page %d\n", j);
      }
    }

    printf("--> %d page verify errors\n", errors);
    if (errors > 0)  // 5120 for entire device
	return 1;
    return 0;
}
